package fr.asip.cps3.exemple.vues.menus;

import java.awt.event.ActionListener;
import fr.asip.cps3.exemple.modele.objets.Token;

/**
 * Classe modlisant un item de menu de type Token
 * @author MCUG
 *
 */
public class ItemMenuToken extends ItemMenu {
	
	private static final long serialVersionUID = 7529493072942486572L;
	
	/**
	 * Token associ  l'item de menu
	 */
	private Token token;

	/**
	 * Constructeur  5 arguments
	 * @param token Token associ  l'item de menu
	 * @param idParent Identifiant du menu parent
	 * @param enable Boolen attestant du caractre actionnable de l'item de menu
	 * @param visible Boolen attestant du caractre visible de l'item de menu
	 * @param ecouteur Ecouteur positionn sur l'item de menu
	 */
	public ItemMenuToken(Token token,String idParent, boolean enable, boolean visible, ActionListener ecouteur) {
		
		super(idParent+",", idParent, "", enable, visible, ecouteur);
		this.token = token;
		if(token != null) {
			setId(getIdParent()+","+token.getIdSlotToken());
			setText(token.getLibelle());
		}
		
	}

	/**
	 * Accesseur
	 * @return Token associ  l'item de menu
	 */
	public Token getToken() {
		return token;
	}


	
}
